/***************************************************************
 *    SimpleViz - A demonstration of a parser
 *    Copyright (C) 2006  Alexander Merz
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package com.alexmerz.simpleviz.parser.data;

import java.util.ArrayList;

import com.alexmerz.graphviz.objects.Id;
import com.alexmerz.graphviz.objects.Node;

/**
 * Implements a global table for the node objects 
 * in a graph 
 * 
 * @author Alexander Merz
 * @version $Id: NodeList.java,v 1.1.1.1 2006/03/29 23:24:15 Alexander Exp $
 */
public class NodeList {

	/**
	 * internal list to store the nodes
	 */
	private ArrayList<Node> nl=new ArrayList<Node>();
	
	/**
	 * Creates a node object and add it to the list
	 * and returns the node.
	 * 
	 * If a node with the same id already exists, the
	 * existing node is returned without creating a new one.
	 * 
	 * @param id the node id
	 * @return the node object
	 */
	public Node addUnique(String id) {
		for(int i=0; i<nl.size();i++) {
			Node n = nl.get(i);			
			if(n.getId().getId().equals(id)) {				
				return n;				
			}
		}
		Node n = new Node();
		Id i = new Id();
		i.setId(id);
		n.setId(i);
		nl.add(n);
		return n;
	}

	/**
	 * Returns a string representation 
	 * of this node object
	 * 
	 * @return the string representation
	 */
	public String toString() {
		return nl.toString();
	}
}
