/***************************************************************
 *    SimpleViz - A demonstration of a parser
 *    Copyright (C) 2006  Alexander Merz
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package com.alexmerz.simpleviz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

import com.alexmerz.simpleviz.parser.ASTStart;
import com.alexmerz.simpleviz.parser.JJTParser;
import com.alexmerz.simpleviz.parser.ParseException;
import com.alexmerz.simpleviz.parser.SimpleNode;
import com.alexmerz.simpleviz.parser.data.NodeList;
import com.alexmerz.simpleviz.visitor.AbstractVisitor;
import com.alexmerz.simpleviz.visitor.NodeListVisitor;

/**
 * This is the main program for calling the SimpleViz parser
 * @author Alexander Merz
 * @version $Id: SimpleViz.java,v 1.1.1.1 2006/03/29 23:24:14 Alexander Exp $
 */
public class SimpleViz {

	/**
	 * Main method
	 * 
	 * @param args Commandline arguments (unused)
	 * @throws ParseException 
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args) throws ParseException, FileNotFoundException {
		FileReader sr = new FileReader(new File("testfiles/simple.sv"));
		JJTParser p = new JJTParser(sr);
		ASTStart node = p.Start();
		node.dump("");

		NodeList sysnl = new NodeList();
		NodeListVisitor nlv = new NodeListVisitor(sysnl);
		
		traverseNodes(node, nlv);		
		System.out.print(sysnl);
	}
	
	/**
	 * Method to going through the syntax tree
	 * @param node the start node
	 * @param visitor the visitor class 
	 */
	private static void traverseNodes(SimpleNode node, AbstractVisitor visitor) {
		for(int i=0;i<node.jjtGetNumChildren();i++) {
			SimpleNode sn = (SimpleNode)node.jjtGetChild(i); 
			sn.jjtAccept(visitor, null);
			traverseNodes(sn, visitor);
		}
	}

}
