/***************************************************************
 *    SimpleViz - A demonstration of a parser
 *    Copyright (C) 2006  Alexander Merz
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package com.alexmerz.simpleviz.visitor;

import com.alexmerz.graphviz.objects.Node;
import com.alexmerz.simpleviz.parser.ASTAttribute;
import com.alexmerz.simpleviz.parser.ASTAttributeList;
import com.alexmerz.simpleviz.parser.ASTNode;
import com.alexmerz.simpleviz.parser.ASTNodeAttribute;
import com.alexmerz.simpleviz.parser.ASTSubgraph;
import com.alexmerz.simpleviz.parser.SimpleNode;
import com.alexmerz.simpleviz.parser.data.NodeList;

/**
 * Implements a visitor class to process the syntax tree
 * to fill the nodelist.
 * 
 * @author Alexander Merz
 * @version $Id: NodeListVisitor.java,v 1.1.1.1 2006/03/29 23:24:15 Alexander Exp $
 */
public class NodeListVisitor extends AbstractVisitor {
	  
	/**
	 * Holds the NodeList
	 */
	private NodeList nl = null;
	
	/**
	 * Constructor
	 * 
	 * @param nl the NodeList to fill
	 */
	public NodeListVisitor(NodeList nl) {
		this.nl = nl;
	}

	/**
	 * Process a NodeList object.
	 * 
	 * Adds a node the NodeList.
	 * 
	 * @param node the NodeList object
	 * @param data unused
	 */
	public Object visit(ASTNode node, Object data) {		
		nl.addUnique(node.getId());
		return null;
	}
	
	/**
	 * Process a ASTNodeAttribute object.
	 * 
	 * Add node to NodeList including attributes.
	 * 
	 * @param nodeAttr the ASTNodeAttribute object
	 * @param data unused 
	 */
	public Object visit(ASTNodeAttribute nodeAttr, Object data) {
		ASTNode node = null;
		ASTAttributeList list = null;
		  
		for(int i =0; i < nodeAttr.jjtGetNumChildren(); i++) {
			SimpleNode sn = (SimpleNode)nodeAttr.jjtGetChild(i);
			// TODO: this is maybe not really reliable
			if(sn.toString().equals("AttributeList")) {
				list = (ASTAttributeList)sn;
			} else if(sn.toString().startsWith("Node")) {
				node = (ASTNode)sn;				  
			}
		}
		if(list != null && node != null) {			 
			Node n = nl.addUnique(node.getId());
			for(int i =0; i < list.jjtGetNumChildren(); i++) {				
				ASTAttribute attrib = (ASTAttribute)list.jjtGetChild(i);
				n.setAttribute(attrib.getKey(), attrib.getValue());
			}
		}							 
		return null;
	}	
	  
	/**
	 * Process a ASTNodeAttribute object.
	 * 
	 * Add subgraph as Node with a special flag to NodeList.
	 * 
	 * @param node the ASTSubgraph object
	 * @param data unused
	 */
	public Object visit(ASTSubgraph node, Object data) {
		Node n = nl.addUnique(node.getId());
		n.representsSubgraph(true);
		return null;
	}	  	
}
