/***************************************************************
 *    SimpleViz - A demonstration of a parser
 *    Copyright (C) 2006  Alexander Merz
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package com.alexmerz.simpleviz.visitor;

import com.alexmerz.simpleviz.parser.ASTAttribute;
import com.alexmerz.simpleviz.parser.ASTAttributeList;
import com.alexmerz.simpleviz.parser.ASTEdge;
import com.alexmerz.simpleviz.parser.ASTGenericAttributeList;
import com.alexmerz.simpleviz.parser.ASTGraph;
import com.alexmerz.simpleviz.parser.ASTNode;
import com.alexmerz.simpleviz.parser.ASTNodeAttribute;
import com.alexmerz.simpleviz.parser.ASTNodePort;
import com.alexmerz.simpleviz.parser.ASTStart;
import com.alexmerz.simpleviz.parser.ASTSubgraph;
import com.alexmerz.simpleviz.parser.JJTParserVisitor;
import com.alexmerz.simpleviz.parser.SimpleNode;

/**
 * Implements all visit() methods required
 * by the JJTParserVisitor interface. Does nothing.
 * 
 * @author Alexander Merz
 * @version $Id: AbstractVisitor.java,v 1.1.1.1 2006/03/29 23:24:15 Alexander Exp $
 */
public abstract class AbstractVisitor implements JJTParserVisitor {

	/**
	 * Process SimpleNode objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */
	public Object visit(SimpleNode node, Object data) {
		return null;
	}

	/**
	 * Process ASTStart objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */
	  
	 public Object visit(ASTStart node, Object data) {
		 return null;
	 }

	 /**
	 * Process ASTGraph objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */	 
	 public Object visit(ASTGraph node, Object data) {
		 return null;
	 }

	/**
	 * Process ASTGenericAttributeList objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */
	 public Object visit(ASTGenericAttributeList node, Object data) {
		 return null;
	 }
	  
	/**
	 * Process SimpleNode objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */
	 public Object visit(ASTAttribute node, Object data) {
		 return null;
	 }

	/**
	 * Process ASTEdge objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */	 
	 public Object visit(ASTEdge node, Object data) {
		 return null;
	 }

	/**
	 * Process ASTNodePort objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */	 
	 public Object visit(ASTNodePort node, Object data) {
		 return null;
	 }

	/**
	 * Process ASTNode objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */	
	 public Object visit(ASTNode node, Object data) {
		 return null;
	 }

	/**
	 * Process ASTNodeAttribute objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */	 
	 public Object visit(ASTNodeAttribute node, Object data) {
		 return null;
	 }

	/**
	 * Process ASTSubgraph objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */	 
	 public Object visit(ASTSubgraph node, Object data) {
		 return null;
	 }

	/**
	 * Process ASTAttributeList objects
	 * 
	 * @param node the syntax tree node
	 * @param data unused 
	 */	  
	 public Object visit(ASTAttributeList node, Object data) {
	 	return null;
	 }
}
