/*
 * Decompiled with CFR 0.152.
 */
package com.alexmerz.graphviz.objects;

import com.alexmerz.graphviz.objects.Id;
import java.util.Enumeration;
import java.util.Hashtable;

public class Node {
    private Id id = null;
    private Hashtable<String, String> attr = new Hashtable();
    private boolean isSubgraph = false;

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public String toString() {
        if (this.isSubgraph()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.id.getId().equals("")) {
            stringBuffer.append(this.id.getId());
        } else if (!this.id.getLabel().equals("")) {
            stringBuffer.append("\"");
            stringBuffer.append(this.id.getLabel());
            stringBuffer.append("\"");
        }
        if (this.attr.size() > 0) {
            stringBuffer.append(" [");
            Enumeration<String> enumeration = this.attr.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                stringBuffer.append(string);
                if (!this.attr.get(string).equals("")) {
                    stringBuffer.append("=");
                    if (-1 == this.attr.get(string).indexOf(" ")) {
                        stringBuffer.append(this.attr.get(string));
                    } else {
                        stringBuffer.append("\"");
                        stringBuffer.append(this.attr.get(string));
                        stringBuffer.append("\"");
                    }
                }
                stringBuffer.append(", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            stringBuffer.append("]");
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public String getAttribute(String string) {
        return this.attr.get(string);
    }

    public void setAttribute(String string, String string2) {
        this.attr.put(string, string2);
    }

    public boolean isSubgraph() {
        return this.isSubgraph;
    }

    public void representsSubgraph(boolean bl) {
        this.isSubgraph = bl;
    }

    public Hashtable<String, String> getAttributes() {
        return this.attr;
    }
}

