/*
 * Decompiled with CFR 0.152.
 */
package com.alexmerz.graphviz.objects;

import com.alexmerz.graphviz.objects.PortNode;
import java.util.Enumeration;
import java.util.Hashtable;

public class Edge {
    private PortNode source = null;
    private PortNode target = null;
    private int type = 0;
    private Hashtable<String, String> attributes = new Hashtable();

    public Edge() {
        this.source = null;
        this.target = null;
        this.type = 0;
    }

    public Edge(PortNode portNode, PortNode portNode2, int n) {
        this.source = portNode;
        this.target = portNode2;
        this.type = n;
    }

    public PortNode getSource() {
        return this.source;
    }

    public void setSource(PortNode portNode) {
        this.source = portNode;
    }

    public PortNode getTarget() {
        return this.target;
    }

    public void setTarget(PortNode portNode) {
        this.target = portNode;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.source.getNode().getId().getId().equals("")) {
            stringBuffer.append(this.source.getNode().getId().getId());
        } else if (!this.source.getNode().getId().getLabel().equals("")) {
            stringBuffer.append("\"");
            stringBuffer.append(this.source.getNode().getId().getLabel());
            stringBuffer.append("\"");
        }
        if (!this.source.getPort().equals("")) {
            stringBuffer.append(":\"");
            stringBuffer.append(this.source.getPort());
            stringBuffer.append("\"");
        }
        if (2 == this.getType()) {
            stringBuffer.append(" -> ");
        } else {
            stringBuffer.append(" -- ");
        }
        if (!this.target.getNode().getId().getId().equals("")) {
            stringBuffer.append(this.target.getNode().getId().getId());
        } else if (!this.target.getNode().getId().getLabel().equals("")) {
            stringBuffer.append("\"");
            stringBuffer.append(this.target.getNode().getId().getLabel());
            stringBuffer.append("\"");
        }
        if (!this.target.getPort().equals("")) {
            stringBuffer.append(":\"");
            stringBuffer.append(this.target.getPort());
            stringBuffer.append("\"");
        }
        if (this.attributes.size() > 0) {
            stringBuffer.append(" [");
            Enumeration<String> enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                stringBuffer.append(string);
                if (!this.attributes.get(string).equals("")) {
                    stringBuffer.append("=");
                    if (-1 == this.attributes.get(string).indexOf(" ")) {
                        stringBuffer.append(this.attributes.get(string));
                    } else {
                        stringBuffer.append("\"");
                        stringBuffer.append(this.attributes.get(string));
                        stringBuffer.append("\"");
                    }
                }
                stringBuffer.append(", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            stringBuffer.append("]");
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public Hashtable<String, String> getAttributes() {
        return this.attributes;
    }
}

