/*
 * Decompiled with CFR 0.152.
 */
package com.alexmerz.graphviz.objects;

import com.alexmerz.graphviz.objects.Edge;
import com.alexmerz.graphviz.objects.Id;
import com.alexmerz.graphviz.objects.Node;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Graph {
    public static final int UNDIRECTED = 1;
    public static final int DIRECTED = 2;
    private Id id = null;
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<Edge> edges = new ArrayList();
    private ArrayList<Graph> graphs = new ArrayList();
    private int type = 0;
    private boolean strictgraph = false;
    private Hashtable<String, String> attributes = new Hashtable();
    private Hashtable<String, String> genericEdgeAttributes = new Hashtable();
    private Hashtable<String, String> genericNodeAttributes = new Hashtable();
    private Hashtable<String, String> genericGraphAttributes = new Hashtable();

    public void addGenericEdgeAttribute(String string, String string2) {
        this.genericEdgeAttributes.put(string, string2);
    }

    public String getGenericEdgeAttribute(String string) {
        return this.genericEdgeAttributes.get(string);
    }

    public void addGenericGraphAttribute(String string, String string2) {
        this.genericGraphAttributes.put(string, string2);
    }

    public String getGenericGraphAttribute(String string) {
        return this.genericGraphAttributes.get(string);
    }

    public void addGenericNodeAttribute(String string, String string2) {
        this.genericNodeAttributes.put(string, string2);
    }

    public String getGenericNodeAttribute(String string) {
        return this.genericNodeAttributes.get(string);
    }

    public void addAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (this.graphs.size() != 0) {
            for (int i = 0; i < this.graphs.size(); ++i) {
                this.graphs.get(i).setType(n);
            }
        }
        this.type = n;
    }

    public boolean isStrict() {
        return this.strictgraph;
    }

    public void setStrict(boolean bl) {
        this.strictgraph = bl;
    }

    public String toString() {
        String string;
        Enumeration<String> enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isStrict()) {
            stringBuffer.append("strict ");
        }
        if (2 == this.getType()) {
            stringBuffer.append("digraph ");
        } else {
            stringBuffer.append("graph ");
        }
        if (!this.id.getId().equals("")) {
            stringBuffer.append(this.id.getId());
        } else if (!this.id.getLabel().equals("")) {
            stringBuffer.append(this.id.getLabel());
        }
        stringBuffer.append(" {\n");
        if (this.attributes.size() > 0) {
            enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                stringBuffer.append(string);
                if (!this.attributes.get(string).equals("")) {
                    stringBuffer.append("=");
                    if (-1 == this.attributes.get(string).indexOf(" ")) {
                        stringBuffer.append(this.attributes.get(string));
                    } else {
                        stringBuffer.append("\"");
                        stringBuffer.append(this.attributes.get(string));
                        stringBuffer.append("\"");
                    }
                }
                stringBuffer.append(";\n");
            }
        }
        if (this.genericNodeAttributes.size() > 0) {
            enumeration = this.genericNodeAttributes.keys();
            stringBuffer.append("node [");
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                stringBuffer.append(string);
                if (!this.genericNodeAttributes.get(string).equals("")) {
                    stringBuffer.append("=");
                    if (-1 == this.genericNodeAttributes.get(string).indexOf(" ")) {
                        stringBuffer.append(this.genericNodeAttributes.get(string));
                    } else {
                        stringBuffer.append("\"");
                        stringBuffer.append(this.genericNodeAttributes.get(string));
                        stringBuffer.append("\"");
                    }
                }
                stringBuffer.append(", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            stringBuffer.append("];\n");
        }
        if (this.genericEdgeAttributes.size() > 0) {
            enumeration = this.genericEdgeAttributes.keys();
            stringBuffer.append("edge [");
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                stringBuffer.append(string);
                if (!this.genericEdgeAttributes.get(string).equals("")) {
                    stringBuffer.append("=");
                    if (-1 == this.genericEdgeAttributes.get(string).indexOf(" ")) {
                        stringBuffer.append(this.genericEdgeAttributes.get(string));
                    } else {
                        stringBuffer.append("\"");
                        stringBuffer.append(this.genericEdgeAttributes.get(string));
                        stringBuffer.append("\"");
                    }
                }
                stringBuffer.append(", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            stringBuffer.append("];\n");
        }
        if (this.genericGraphAttributes.size() > 0) {
            enumeration = this.genericGraphAttributes.keys();
            stringBuffer.append("graph [");
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                stringBuffer.append(string);
                if (!this.genericGraphAttributes.get(string).equals("")) {
                    stringBuffer.append("=");
                    if (-1 == this.genericGraphAttributes.get(string).indexOf(" ")) {
                        stringBuffer.append(this.genericGraphAttributes.get(string));
                    } else {
                        stringBuffer.append("\"");
                        stringBuffer.append(this.genericGraphAttributes.get(string));
                        stringBuffer.append("\"");
                    }
                }
                stringBuffer.append(", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            stringBuffer.append("];\n");
        }
        if (this.nodes.size() > 0) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                stringBuffer.append(this.nodes.get(i).toString());
            }
        }
        if (this.edges.size() > 0) {
            for (int i = 0; i < this.edges.size(); ++i) {
                stringBuffer.append(this.edges.get(i).toString());
            }
        }
        if (this.graphs.size() > 0) {
            for (int i = 0; i < this.graphs.size(); ++i) {
                stringBuffer.append(this.graphs.get(i).toString());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public ArrayList<Graph> getSubgraphs() {
        return this.graphs;
    }

    public void addSubgraph(Graph graph) {
        this.graphs.add(graph);
    }

    public Node findNode(Id id) {
        Node node = null;
        Id id2 = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            node = this.nodes.get(i);
            id2 = node.getId();
            if (!id2.isEqual(id)) continue;
            return node;
        }
        for (int i = 0; i < this.graphs.size(); ++i) {
            Graph graph = this.graphs.get(i);
            node = graph.findNode(id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public ArrayList<Node> getNodes(boolean bl) {
        if (bl) {
            return this.nodes;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodes);
        Graph graph = null;
        for (int i = 0; i < this.graphs.size(); ++i) {
            graph = this.graphs.get(i);
            arrayList.addAll(graph.getNodes(false));
        }
        return arrayList;
    }

    public Hashtable<String, String> getAttributes() {
        return this.attributes;
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }
}

