/*
 * Decompiled with CFR 0.152.
 */
package com.alexmerz.graphviz.cli;

import com.alexmerz.graphviz.ParseException;
import com.alexmerz.graphviz.Parser;
import com.alexmerz.graphviz.objects.Edge;
import com.alexmerz.graphviz.objects.Graph;
import com.alexmerz.graphviz.objects.Id;
import com.alexmerz.graphviz.objects.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class gvv {
    static final int NOFILE = 11;
    static final int FILENOTFOUND = 12;
    static final int PROCESSING = 13;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            gvv.errorDie(11, "");
        }
        if (stringArray[0].equals("-h") || stringArray[0].equals("--help")) {
            gvv.showUsage();
            System.exit(0);
        } else {
            gvv.go(stringArray[0]);
            System.exit(0);
        }
    }

    private static void errorDie(int n, String string) {
        if (n == 11) {
            System.err.println("ERROR: You must provide a Graphviz file!\n");
            gvv.showUsage();
        } else if (n == 12) {
            System.err.println("ERROR: " + string + "\n");
        } else if (n == 13) {
            System.err.println("ERROR: " + string + "\n");
        }
        System.exit(n);
    }

    private static void showUsage() {
        System.out.print("Usage: java -jar graphviz.jar <file>\n");
    }

    private static void go(String string) {
        FileReader fileReader = null;
        File file = new File(string);
        try {
            fileReader = new FileReader(file);
            Parser parser = new Parser();
            parser.parse(fileReader);
            gvv.show(parser);
        }
        catch (FileNotFoundException fileNotFoundException) {
            gvv.errorDie(12, "Could not found " + file.getAbsolutePath());
        }
        catch (ParseException parseException) {
            gvv.errorDie(13, parseException.getMessage());
        }
    }

    private static void show(Parser parser) {
        Graph graph = null;
        ArrayList<Node> arrayList = null;
        ArrayList<Edge> arrayList2 = null;
        ArrayList<Graph> arrayList3 = null;
        ArrayList<Graph> arrayList4 = parser.getGraphs();
        for (int i = 0; i < arrayList4.size(); ++i) {
            int n;
            graph = arrayList4.get(0);
            System.out.print(gvv.getGraphData(graph, ""));
            System.out.print("\n");
            arrayList = graph.getNodes(false);
            for (n = 0; n < arrayList.size(); ++n) {
                System.out.print(gvv.getNodeData(arrayList.get(n), ""));
                System.out.print("\n");
            }
            arrayList2 = graph.getEdges();
            for (n = 0; n < arrayList2.size(); ++n) {
                System.out.print(gvv.getEdgeData(arrayList2.get(n), ""));
                System.out.print("\n");
            }
            arrayList3 = graph.getSubgraphs();
            for (n = 0; n < arrayList3.size(); ++n) {
                System.out.print(gvv.getSubgraphData(arrayList3.get(n), ""));
                System.out.print("\n");
            }
            System.out.print("%%\n");
        }
    }

    private static String getSubgraphData(Graph graph, String string) {
        int n;
        String string2 = "";
        String string3 = "";
        string3 = !graph.getId().getId().equals("") ? graph.getId().getId() : graph.getId().getLabel();
        String string4 = "SUBGRAPH: " + string3 + " : " + string;
        ArrayList<Node> arrayList = null;
        ArrayList<Edge> arrayList2 = null;
        ArrayList<Graph> arrayList3 = null;
        string2 = string2 + gvv.getGraphData(graph, string4);
        string2 = string2 + "\n";
        arrayList = graph.getNodes(false);
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = string2 + gvv.getNodeData(arrayList.get(n), string4);
            string2 = string2 + "\n";
        }
        arrayList2 = graph.getEdges();
        for (n = 0; n < arrayList2.size(); ++n) {
            string2 = string2 + gvv.getEdgeData(arrayList2.get(n), string4);
            string2 = string2 + "\n";
        }
        arrayList3 = graph.getSubgraphs();
        for (n = 0; n < arrayList3.size(); ++n) {
            string2 = string2 + gvv.getSubgraphData(arrayList3.get(n), string4);
            string2 = string2 + "\n";
        }
        return string2;
    }

    private static String getEdgeData(Edge edge, String string) {
        String string2 = "EDGE: ";
        string2 = !edge.getSource().getNode().getId().getId().equals("") ? string2 + edge.getSource().getNode().getId().getId() : string2 + "\"" + edge.getSource().getNode().getId().getLabel() + "\"";
        string2 = string2 + "(" + edge.getSource().getPort() + ")";
        if (edge.getSource().getNode().isSubgraph()) {
            string2 = string2 + "[*]";
        }
        string2 = edge.getType() == 2 ? string2 + " -> " : string2 + " -- ";
        string2 = !edge.getTarget().getNode().getId().getId().equals("") ? string2 + edge.getTarget().getNode().getId().getId() : string2 + "\"" + edge.getTarget().getNode().getId().getLabel() + "\"";
        string2 = string2 + "(" + edge.getTarget().getPort() + ")";
        if (edge.getTarget().getNode().isSubgraph()) {
            string2 = string2 + "[*]";
        }
        String string3 = "";
        Hashtable<String, String> hashtable = edge.getAttributes();
        Enumeration<String> enumeration = hashtable.keys();
        String string4 = "";
        while (enumeration.hasMoreElements()) {
            string4 = enumeration.nextElement();
            string3 = string3 + string + string2 + " : PROPERTY " + string4 + "=" + hashtable.get(string4) + "\n";
        }
        if (string4.equals("")) {
            string3 = string2 + "\n";
        }
        return string3.substring(0, string3.length() - 1);
    }

    private static String getNodeData(Node node, String string) {
        String string2 = "";
        Enumeration<String> enumeration = null;
        Hashtable<String, String> hashtable = null;
        string2 = !node.getId().getId().equals("") ? node.getId().getId() : "\"" + node.getId().getLabel() + "\"";
        String string3 = string + "NODE: " + string2 + " : ID=" + node.getId().getId() + "\n" + string + "NODE: " + string2 + " : LABEL=" + node.getId().getLabel() + "\n";
        hashtable = node.getAttributes();
        enumeration = hashtable.keys();
        String string4 = "";
        while (enumeration.hasMoreElements()) {
            string4 = enumeration.nextElement();
            string3 = string3 + string + "NODE: " + string2 + " : PROPERTY " + string4 + "=" + hashtable.get(string4) + "\n";
        }
        return string3.substring(0, string3.length() - 1);
    }

    private static String getGraphData(Graph graph, String string) {
        String string2 = string + "GRAPH: ID=" + graph.getId().getId() + "\n" + string + "GRAPH: LABEL=" + graph.getId().getLabel() + "\n" + string + "GRAPH: STRICT=" + (graph.isStrict() ? "true" : "false") + "\n" + string + "GRAPH: DIRECTION=" + (graph.getType() == 2 ? "directed" : "undirected");
        Hashtable<String, String> hashtable = graph.getAttributes();
        Enumeration<String> enumeration = hashtable.keys();
        String string3 = "";
        while (enumeration.hasMoreElements()) {
            string3 = enumeration.nextElement();
            string2 = string2 + "\n" + string + "GRAPH: PROPERTY " + string3 + "=" + hashtable.get(string3);
        }
        if (string3.equals("")) {
            string2 = string2 + "\n";
        }
        ArrayList<Node> arrayList = graph.getNodes(false);
        Id id = null;
        if (arrayList.size() > 0 && !string3.equals("")) {
            string2 = string2 + "\n";
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = string2 + string + "GRAPH: NODE=";
            id = arrayList.get(i).getId();
            string2 = !id.getId().equals("") ? string2 + id.getId() : string2 + "\"" + id.getLabel() + "\"";
            string2 = string2 + "\n";
        }
        return string2.substring(0, string2.length() - 1);
    }
}

