/*
 * Decompiled with CFR 0.152.
 */
package com.alexmerz.graphviz;

import com.alexmerz.graphviz.TokenMgrError;

public class GraphvizTokenMgrError {
    public static final int DIRECTED_EDGE_NOT_ALLOWED = 1;
    public static final int UNDIRECTED_EDGE_NOT_ALLOWED = 2;

    public static TokenMgrError create(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                return GraphvizTokenMgrError.createDirectedEdgeError(n2, n3);
            }
            case 2: {
                return GraphvizTokenMgrError.createUndirectedEdgeError(n2, n3);
            }
        }
        return new TokenMgrError("Unspecific error", 0);
    }

    private static TokenMgrError createDirectedEdgeError(int n, int n2) {
        String string = "A directed edge is not allowed in an undirected graph. Use an \"--\" instead \"->\".";
        return GraphvizTokenMgrError.createError(string, n, n2);
    }

    private static TokenMgrError createUndirectedEdgeError(int n, int n2) {
        String string = "A undirected edge is not allowed in a directed graph. Use an \"->\" instead \"--\".";
        return GraphvizTokenMgrError.createError(string, n, n2);
    }

    private static TokenMgrError createError(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" Error at Line " + Integer.toString(n));
        stringBuffer.append(", Column " + Integer.toString(n2));
        return new TokenMgrError(stringBuffer.toString(), 0);
    }
}

